/* This class customizes Analyzer for the specific kind of lexical analysis required to parse Actor source code. */ !!



/* inherit(Analyzer, #ActorAnalyzer, #(
createFlag 
level 
commentPos 
isReal), nil, nil) */ !!

now(ActorAnalyzerClass) !!

Actor[#NestInTokens] := asSet(tuple(#if, #loop, #case, #select,
 asInt('{')))!!

Actor[#NestOutTokens] := asSet(tuple(#endif, #endLoop, #endCase, 
 #endSelect, asInt('}')))!!

now(ActorAnalyzer) !!

/* Report that the end of the input being 
  analyzed was reached before expected. */
Def eosError(self, bp, str)
{ syntaxError(CurrentParser, bp, str);
} !!

/*  Return a TextCollection containing 
  formatted lines of source.  Input is the 
  string currently owned by the analyzer in 
  its collection variable.  The width 
  argument is the current width of the 
  window in characters. */
Def formatLines(self, width | aTC, str )
{   createFlag := nil;
  reset(self);
  level := 0;
  aTC := new(TextCollection, 10);
  loop
  while  (str := nextLine(self))
  begin  add(aTC, str);
  endLoop;
  aTC := commentBreaks(aTC);
  ^lengthBreaks(aTC, width-1);
} !!

/* Return a properly indented source 
  line.  st is the starting offset in the 
  string to scan, and tok is the first 
  token that was found. */
Def sourceLine(self, st, tok | str, lev)
{
  if st >= position
  then ^nil
  endif;
  str := leftJustify(copyFrom(collection, 
    st, position));
  if tok in NestInTokens
  then level := level + 1;
  endif;
  lev := level;
  if tok in NestOutTokens
  then level := level - 1;
  endif;
  if (KeyWords[tok] or tok == asInt('{') 
    or tok == asInt('}')) and tok ~= #self 
    and tok ~=
    #Def and tok ~= #using
  then lev := lev - 1;
  endif;
  ^tabs(lev) + str;
} !! 
 

/* Return the next source line from the 
  input stream, based on  sensible 
  formatting criteria.  Called by 
  formatLines. */
Def nextLine(self | aStr, start, tStart, 
  tok0)
{
  if atEnd(self)
  then ^nil
  endif;
  start := position;
  getToken(self);
  tok0 := val;
  loop
  while not(atEnd(self))
  begin     tStart := position;
    getToken(self);
    if val == asInt(';')
    then  ^sourceLine(self, start, tok0);
    endif;
    if (KeyWords[val] and val ~= #self 
      and val ~= #using)   or val == asInt( 
      '{') or val == asInt('}') or 
      class(val) == String
    then position := tStart;
      ^sourceLine(self, start, tok0);
    endif;
  endLoop;
  ^sourceLine(self, start, tok0);
} !! 
 




 