/* Chars are elements of strings that follow the
 ASCII sequence, such as 'a', 'J', and '&'.

 Chars are distinguished from Strings of length
 one by the fact that they are surrounded by
 single rather than double quotes.  */!!

/* inherit(Magnitude, #Char, nil, nil, nil) */!!

now(class(Char)) !!

now(Char) !!

/* Display the character in the current
  output ports. */
Def print(self)
{ do(OutPorts,
  {using(p) printChar(p, self)
  });
}!!

/* Return a string of num instances of
  the receiver.  For example,
  stringOf('a', 5) returns "aaaaa". */
Def stringOf( self, num)
{ ^fill(new(String, num), self);
}!!

/* Print the Char onto the specified stream.  */
 Def printOn(self, aStrm )
{  nextPutAll(aStrm, asString(self));
}!!


/* Return receiver as a Symbol.
  Example: asSymbol('f') returns #f. */
 Def  asSymbol(self)
{       ^asSymbol(asString(self));
}!!

/* Convert a Char to upper case.
  Characters which are not lower-case
  letters are not affected. */
Def asUpperCase(self)
{  ^if between(self, 'a', 'z')
  then asChar(asInt(self) - 32);
  else self
  endif;
}!!

/* Return true if receiver is 'a'-'f' or
  'A'-'F'. */
 Def isHexDigit(self)
{  ^between(asUpperCase(self),'A','F');
}!!


/* Greater than.  If the argument's
  ASCII value is greater than the
  receiver's, then this method returns
  true.  */
Def >(self, aChar)
{       ^asInt(aChar) > asInt(self);
}!!

/* Less than.  If the argument's
  ASCII value is less than the
  receiver's, then this method returns
  true.  */
 Def <(self, aChar)
{ ^asInt(aChar) < asInt(self);
}!!

/* Greater than or equal to.  If the
  argument's ASCII value is greater than
  or equal to the receiver's, then this
  method returns true.  */
Def >=(self, aChar)
{       ^asInt(aChar) >= asInt(self);
}!!

/* Less than or equal to.  If the
  argument's ASCII value is less than
  or equal to the receiver's, then this
  method returns true.  */
Def <=(self, aChar)
{       ^asInt(aChar) <= asInt(self);
}!!


/* Return the number that self represents
  in the specified base.  For instance, in
  hexadecimal, 'F' is decimal 15, so
  asDigit('F', 16) would return the number
  15.

  Bases from 2 to 36, inclusive, are valid.
  The result of this method with bases outside
  this range is undefined.

  If the receiver is not valid for the
  specified base, i.e. asDigit('H', 16),
  or asDigit('2', 2), then nil is returned.

  Case of the receiver is not important--asDigit('f', 16)
  is the same as asDigit('F', 16). */
Prim asDigit(self, base):Int!!


/* Return a character's ASCII value. */
Prim asInt(self):Int!!


/* Return a character as a String.  For
  example, asString('e') returns "e".  */
Prim asString(self):String!!


/* Return a Char's hash value. */
Prim hash(self):Int!!

/* Return true if the receiver is a
  printable character (ASCII value in the
  range 32 to 126, inclusive). */
Prim isPrintable(self):Boolean!!


/* sysPrint the receiver onto the
  specified stream.  */
Prim sysPrintOn(self, aStrm):Stream!!

/* Return a symbol according to the
  classification of the receiver.  For
  example, classify('h') returns #alpha,
  and classify('5') returns #digit.  */
Prim classify(self):Symbol!!