/* Int is the class for all integer numbers in the
 range -2**14 to (2**14)-1 inclusive (-16384 to 16383).  */  !!

/* inherit(Number, #Int, nil, nil, nil) */!!

now(class(Int))!!

now(Int) !!

/* Generality for Int objects.  Return
  0.  */
Def generality(self)
{ ^0
}!!


/* Return self as a Real number.  For 
  example, asReal(18) returns 18..  */
Def asReal(self)
{       ^asReal(asLong(self))
}!!

/* Return a string of 2*self spaces.
  If self is less than or equal to zero,
  an empty string ("") is returned.  */
 Def  tabs(self)
{  ^fill(new(String, 2*max(0,self)), ' ');
}!!


/* Return the message used to coerce 
  other numerics to this class.  */
 Def converterFor(self)
{ ^#asInt;
}!!

/* Return the String from the resource 
  file having the receiver as a resource 
  ID.  The maximum length of the String
  is 80.  */
 Def loadString(self | str, hnd)
{ hnd := Call GlobalAlloc(0xF40, 80);
  if hnd > 0
  then Call LoadString(HInstance, self, 
    Call GlobalLock(hnd), 80);
    str := removeNulls(getText(hnd));
    Call GlobalUnlock(hnd);
    Call GlobalFree(hnd);
  endif;
  ^str;
}!!

/* Return a Rect object with the receiver
  as the corner's x coordinate.  The rest
  of the rectangle is defined by the
  arguments.  */
Def   rect(self, top, right, bottom)
{ ^init(new(Rect), self, top, right,
  bottom)
}!!


/* Enumerate the one-argument block over
  the Interval 0 to self (step=1). */
 Def  do(self, aBlock)
{       ^do(over(Interval, 0, self),
  aBlock);
}!!

/* Return an Interval object starting at
  self, stopping at endIdx, with step size
  1.  This is the primary way to create
  Interval objects, rather than to send a
  new message to Interval.  For example,
  the message over(0,15) creates the
  Interval 0..15, with step size 1. */
 Def  over(self, endIdx)
{       ^new(Interval, self, endIdx, 1);
}!!


/* Return an Interval object starting at
  self, stopping at endIdx, with step size
  step.  This is the primary way to create
  Interval objects, rather than to send a
  new message to Interval.  For example,
  the message overBy(0,15,2) creates the
  Interval 0..15, with step size 2. */
 Def overBy(self, endIdx, stepSize)
{ ^new(Interval, self, endIdx, stepSize);
}!!

/* Print the Int onto the specified
  Stream.  All integers by default display
  themselves in base 10.  */
 Def printOn(self, aStrm)
{  nextPutAll(aStrm, asString(self, 10))
}!!

/* Return self.  Included only so that
  you can send asInt messages to any
  number.  */
Def  asInt(self)
{
}!!


/* Return true if the receiver is not
  zero.  */
Def  asBool(self)
{       ^(self <> 0)
}!!

/* Return the receiver as it would be
  represented as a digit.  For instance,
  asDigit(3) returns '3'.  For receivers
  not in the range 0..9, inclusive, asDigit
  returns the character digit that
  corresponds to the receiver.  For
  example, in numeric bases 16 and above,
  the decimal number 15 is represented
  as the letter 'F'.  Therefore,
  asDigit(15) returns 'F'.

  This method is only valid for receivers
  in the range '0'..'9' and 'A'..'Z' (inclusive)
  because there are only 36 possible digits (10
  numbers + 26 letters).  The character that
  asDigit returns for receivers outside this
  range is undefined.  */
 Def  asDigit(self)
{
  if self > 9
  then ^asChar(self + 55);
  else ^asChar(self + 48);
  endif;
}!!

/* Return a handle to a predefined
  MS-Windows stock object such as a brush, 
  pen, or font.  (Stock object is the term
  that MS-Windows uses; it does not refer
  to object in the Actor sense.)  */
 Def stock(self)
{ ^Call GetStockObject(self)
}!!

/* Return the low order two bytes of
  an Int.  The low order bytes of an Int
  are the Int itself, since there are no
  high order bytes. */
Def  low(self)
{
}!!


/* Return the two high order bytes of an 
  Int. Since there are no high order bytes
  in an Int, high for this class returns
  0. */
Def high(self)
{ ^0
}!!


/* Multiplication operator.  Example: 3*4.
*/
Prim *(self, y):Int!!


/* Addition operator.  Example: 3+4. */
Prim +(self, y):Int!!


/* Subtraction operator.  Example: 10-2. */
Prim -(self, y):Int!!

/* Return absolute value of self. */
Prim abs(self):Int!!


/* Division operator.  If both operands
  are integers (i.e. either Ints or Longs),
  then integer division is performed.  For
  example, 3/4 is 0, whereas 3.0/4 is
  0.75.  Note that the receiver Int is
  actually the numerator, i.e. in the
  message 3/4, 3 receives the message. */
Prim /(self, numerator):Int!!

/* Less than.  If the argument is less
  than the receiver, then this method
  returns true.  In the message 14<3, 3 is
  the receiver of the < message and 14 is
  the argument.  */
 Prim <(self, y):Boolean!!

/* Less than or equal to.  If the
  argument is less than or equal to the
  receiver, then this method returns true.
  In the message 14<=3, 3 is the receiver
  of the <= message and 14 is the argument.
  */
 Prim <=(self, y):Boolean!!


/* Equals.  If the receiver is equal to
  the argument, then this method returns
  true.  In the message 14=3, 14 is the
  receiver of the = message and 3 is the
  argument.  */
Prim =(self, y):Boolean!!

/* Greater than.  If the argument is
  greater than the receiver, then this
  method returns true.  In the message 14>3,
  3 is the receiver of the > message and 14
  is the argument.  */
 Prim >(self, y):Boolean!!

/* Greater than or equal to.  If the
  argument is greater than or equal to the
  receiver, then this method returns true.
  In the message 14>=3, 3 is the receiver
  of the >= message and 14 is the argument.
  */
 Prim >=(self, y):Boolean!!


/* Return the receiver as a String in the
  specified base.  For example,
  asString(100,2) returns "1100100",
  which is what decimal 100 is in base 2.
  Any number can be displayed in
  hexadecimal format by using 16 as a
  base, for instance.  */
Prim asString(self, base):String!!

/* Not equal.  If the receiver is not
  equal to the argument, then this method
  returns true. In the message 14<>3, 3 is
  the receiver of the <> message and 14 is
  the argument. */
 Prim <>(self, y):Boolean!!


/* Return a Char whose ASCII code is
  equal to the receiver.  For instance,
  asChar(32) returns ' ' (a space).  */
Prim asChar(self):Char!!

/* Return the receiver as a Long
  integer.  For example, asLong(38)
  returns 38L.  */
Prim asLong(self):Long!!

/* Bitwise AND operator.  Return the
  result of the receiver bitwise ANDed with
  the argument.  */
 Prim bitAnd(self, y):Int!!


/* Bitwise OR operator.  Return the
  result of the receiver bitwise ORed
  with the argument.  */
Prim bitOr(self, y):Int!!

/* Bitwise XOR operator.  Return the
  result of the receiver bitwise XORed
  with the argument.  */
Prim bitXor(self, y):Int!!

/* Return text from MS-Windows.  The
  receiver must be a valid handle to the
  text.  The returned string is in ASCIIZ
  format.  */
 Prim getText(self):String!!



/* Return the maximum of two Ints.
  For instance, max(3,4) returns 4.  */
Prim max(self, y):Int!!

/* Return the minimum of two Ints. For
  instance, min(3,4) returns 3.  */
 Prim min(self, y):Int!!

/* Modulus operator.  Return the
  remainder after dividing the argument by
  the receiver.  For instance, 7/5 is 1,
  with remainder 2.  Thus, 7 mod 5 is 2.  */
 Prim mod(self, y):Int!!

/* Return the negative of the receiver.
  For instance, negate(3) returns -3.
  negate(-49) returns 49.  Zero, of course,
  has no negative, so negate(0) is 0.  */
 Prim negate(self):Int!!


/* Return true (specifically, it returns
  the receiver Int) if the receiver is
  negative (less than zero).  Note that
  zero is neither negative nor positive.  */
 Prim negative(self):Boolean !!



/* Return true (specifically, it returns
  the receiver Int) if the receiver is
  nonzero.  */
 Prim nonZero(self):Boolean!!

/* Return a Point object with an x value
  of the receiver and a y value of the
  argument.  For example, point(3,7)
  returns 3@7.  */
Prim point(self, y):Point!!

/* Return true (specifically, it returns
  the receiver Int) if the receiver is
  positive (greater than zero).  Note that
  zero is neither negative nor positive.  */
 Prim positive(self):Boolean!!

/* Return a random Int between 0 and
  (self-1), inclusive.  A random message
  to a negative Int is not defined.  */
Prim random(self):Int!!

/* Return true (specifically, it returns
  0) if the receiver is zero.  */
 Prim zero(self):Boolean!!

/* If the receiver Int is the address of a valid
  activation record, return the address in the form
  of another Int of the previous activation record
  on the Actor stack.  */
Prim stackLink(self):Int !!