/* MethodDictionary objects holds key/value pairs with
 lookups based upon equivalence, as opposed to equality.
 This is more efficient in terms of both time and space
 than Dictionary, but less general.  Since the keys are
 looked up on the basis of equivalence rather than equality,
 this restricts the keys of MethodDictionaries to be objects
 for which equivalence is meaningful, such as Char, Int, and
 Symbol.

 All MethodDictionary objects are allocated out of static memory.
 If you want objects with all the properties of MethodDictionary
 instances, but allocated out of dynamic memory, please see the
 IdentityDictionary class. */  !!

/* inherit(Dictionary, #MethodDictionary, #(values),
2, 1) */!!

now(class(MethodDictionary)) !!

/* Returns a new MethodDictionary with the specified
  number of elements.  */
Prim new(self, size):MethodDictionary!!

now(MethodDictionary) !!

/* Evaluate the keys of the receiver over the one-argument
  block.  This method overrides Dictionary's keysDo method. */
Def keysDo(self, aBlock)
{       ^keysDo(self:KeyedCollection, aBlock);
}!!

/* Evaluate the elements of the receiver over the one-argument
  block.  */
Def do(self, aBlock)
{       ^do( new(Interval, 0, limit(self), 1),
        { using(x)
                if at(self:Object, x)
                then  eval(aBlock, values[x]);
                else  nil
                endif;
        });
}!!

/*  Return the key part of an element.  (Private method) */
Def getKey(self, elem)
{ ^elem }!!

/*  Return the value residing at the specified physical
  index.  (Private method)  */
Def getVal(self, idx)
{  ^values:Object[idx]; }!!

/*  Store a new key/value pair at the specified index.  (Private
  method)  */
Def putElem(self, key, val, idx)
{       put(self:Object, key, idx);
        values:Object[idx] := val;
}!!


/* sysPrint the MethodDictionary onto the specified stream.  */
Def sysPrintOn(self, aStrm)
{ sysPrintOn(self:KeyedCollection, aStrm);
} !!

/* Grow a MethodDictionary so that it
  can hold more elements.  Works by copying
  elements into larger collection and then
  swapping object pointers with the new
  collection.  Overrides Dictionary's grow method.  */
Def grow(self)
{ ^grow(self:KeyedCollection);
}!!

/* Place anElement into the collection corresponding to aKey.
  Overrides Dictionary's put method.  */
Def put(self, aKey, anElement)
{ ^add(self, anElement, aKey);
}!!

/* Return the key corresponding to the specified value
  (there may be several keys with the same value, but not vice-versa). */
Def  keyAt(self, aVal | idx)
{       if (idx := indexOf(values:Array, aVal))
   then ^at(self:Object, idx);
   endif;
   ^nil;
}!!

/* Empty the MethodDictionary completely of all keys and elements.
  All keys and elements are set to nil.  */
Def  clear(self)
{       fill(values, nil);
        clear(self:KeyedCollection);
} !!

/* Add the specified key and element to
  the MethodDictionary receiver.  */
 Prim add(self, anElement,
  aKey):MethodDictionary!!

/* Return the element residing at the
  specified key.  */
Prim at(self, aKey):AnElement!!

/* Return the physical index of the
  specified key.  */
Prim find(self, aKey):Int!!

/* Initialize the receiver by
  setting the tally instance variable
  to zero.  */
Prim init(self):MethodDictionary!!
