/* Slots are collections of key/value pairs (i.e., a Dictionary).
  Each facet in the slot is an entry in the dictionary. */     !!

inherit(Dictionary, #Slot, #(name  /* Name of the slot */
        ifNeeded  /* Demon (an Actor block) */
        ifAdded   /* Demon */
        ifRemoved /* Demon */), 2, 1) !!

now(SlotClass) !!

/* Create and return a new slot with space for 4 facets and an
  automatic value facet. */
Def new(self, sName | sl)
  { sl := new(self:CollectionClass, 4);
  sl.name := sName;
  sl [#value] := nil;
  ^sl
  }!!

now(Slot) !!

/* Set the value facet of the slot. */
Def  setValue(self, val)
{ self[#value] := val;
} !!


/* Get the value facet of the slot. */
Def  getValue(self, val)
{ ^self[#value];
} !!

/* Print the key and value of the slot onto the
  specified stream.  */

Def printOn(self, strm)
{ printOn(name + ":", strm);
  printOn(self[#value], strm);
  printOn(' ',strm);
}!!
