;********************************************************************
;*                                                                  *
;*      HARD DISK DRIVER LINK PROGRAM                               *
;*      S100 BUS/S1410                                              *
;*                                                                  *
;*      CP/M 80               S100 BUS HOST COMPUTER                *
;*                                                                  *
;*      COPYRIGHT 1982        XEBEC CORP                            *
;*                            432 LAKESIDE DR.                      *
;*                            SUNNYVALE, CA. 94086                  *
;*                                                                  *
;********************************************************************
;
;
;S100 BUS LINK PROGRAM
;REV. 2.0  02-11-82
;
;
;REVISION HISTORY
;**********************************************
;
;AUGUST 20,1982...INITIAL RELEASE
;
;FEBRURAY 11, 1983 .... INSTALL CAPS. TO REMOVE DRIVE 'D'
;
;THIS PROGRAM MOVES THE 1K HARD DISK 
;DRIVER TO A SPECIFIED AREA IN MEMORY,
;LINKS IT TO THE USER BIOS JUMP TABLE,
;AND RETURNS TO CP/M
;
;THE FOLLOWING EQUATE MUST BE SET
;FOR THE STARTING ADDRESS OF THE
;DRIVER.  NOTE THAT IT MUST BE THE 
;SAME AS THE EQUATE IN THE PROGRAM
;"HDDVR.ASM"
;
;
;
START	EQU	0D800H	;HARD DISK DRIVER STARTING ADDRESS
;
	ORG	0100H	;
	LXI	H,START		;MOVE TO ADDRESS
	LXI	D,0400H		;FROM ADDRESS
	LXI	B,03FFH		;1K BYTES
;
;MOVE 1K BYTES FROM 0400H TO 
;THE DRIVER STARTING ADDRESS
LOOP:			;
	LDAX	D	;
	MOV	M,A	;SAVE IT
	INX	H	;
	INX	D	;
	DCX	B	;
	MOV	A,C	;
	CPI	0	;
	JNZ	LOOP	;
	MOV	A,B	;
	CPI	0	;
	JNZ	LOOP	;COUNT TO 1024
;
;LINK TO BIOS
;
	LHLD	1	;PICK UP JUMP TABLE ADDRESS
	MVI	L,04H		;PATCH WARM BOOT
	SHLD	START+1H	;
	SHLD	START+3AH	;
	MVI	L,19H		;PATCH HOME
	SHLD	START+07H	;
	SHLD	START+40H	;
	MVI	L,1CH		;PATCH SELECT
	SHLD	START+0DH	;
	SHLD	START+46H	;
	MVI	L,1FH		;PATCH SELECT TRACK
	SHLD	START+13H	;
	SHLD	START+4CH	;
	MVI	L,22H		;PATCH SELECT SECTOR
	SHLD	START+19H	;
	SHLD	START+52H	;
	MVI	L,25H		;PATCH SETDMA
	SHLD	START+1FH	;
	SHLD	START+58H	;
	MVI	L,28H		;PATCH READ
	SHLD	START+25H	;
	SHLD	START+5EH	;
	MVI	L,2BH		;PATCH WRITE
	SHLD	START+2BH	;
	SHLD	START+64H	;
	MVI	L,31H		;PATCH TRANSLATE
	SHLD	START+31H	;
	SHLD	START+6AH	;
				;
				;
	LHLD	1	;PICK UP DIRBUF ADDRESS
	MVI	C,0		;
	MVI	L,01BH		;CALLING SELECT DISC ROUTINE
	SHLD	SELCAL+1	;MODIFY CALLING ADDRESS
SELCAL:				;
	CALL	0		;ADDRESS IS MODIFIED BEFORE CALL
				;H,L HAVE ADDRESS OF DISC PARM TABLE
	INX	H		;NOW, ADD 8 BYTES TO POINTER TO GET DIRBUF
	INX	H		;
	INX	H		;
	INX	H		;
	INX	H		;
	INX	H		;
	INX	H		;
	INX	H		;
				;
				;H,L POINT TO DIRBUF POINTER
	SHLD	FINDBF+1		;MODIFY CODE
	LHLD	START+256	;GET PATCH LOCATIONS
	SHLD	BUF1+1		;
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;	LHLD	START+258	;REMOVE COMMENT SYMBOL       FOR TWO DRIVE
;	SHLD	BUF2+1		;REMOVE COMMENT SYMBOL          SUPPORT
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
				;
FINDBF:				;
	LHLD	0		;
				;
BUF1:				;
	SHLD	0		;
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;BUF2:				;REMOVE COMMENT SYMBOL       FOR TWO DRIVE 
;	SHLD	0		;REMOVE COMMENT SYMBOL          SUPPORT 
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;
;TWO DRIVE DIRBUF AREAS TO PATCH AT BUF AND BUF2
;
	CALL	START	;LINK TO FD BIOS
	JMP	0	;RETURN TO CP/M
	END		;
