
//		Wrapper for SuperPaint code & interface to Windows.
//		Mostly ideas and code pieces taken from re-creation 
//		of Alvy's Paint3 program by Jack Newlevant.
//		-- R. Shoup, 9/05


#include <stdio.h>
#include <windows.h>
#include <commdlg.h>
#include "resource.h"
#include "MyDefs.h"

char *appName = "SuperPaint";
char *winName[nFB] = { "SuperPaint'78 - Menu", "SuperPaint'78 - Canvas", 
					   "", "SuperPaint'78 - Terminal" };

int TXPos, TYPos, Tfb, retv;
int LbDown, RbDown, Focfb;
HANDLE Thread, LbDownEv, RbDownEv;
HCURSOR HCurs;
RTL_CRITICAL_SECTION EvLock;
char CmdLine[200];

byte	MyPix[FBHeight][FBWidth];	// FB pixels 
RGBQUAD	MyCMap[nMColors];			// color map 
int		SPMode = -1;				// 0-normal, 1-swap, 2-overlay, 3-getpic
byte	CMapMode;					// color map mode, 0=>Q0&Q1, 010=>Q1, 014=>Q0 
pane	FB[nFB];					// info about each window 


DWORD MyMain(LPVOID arg) {		/* init & execute the SuperPaint code */
	int i; char s[100] = "";
	char *modestr[] = { "(Normal mode)","(Swap Mode)","(Overlay Mode)","(8-bit GetPic)" };

	if (SPMode<0) {				// if not set yet
		MyTextOut(TermFB,TermXo,TermYo," Select operating mode:");
		MyTextOut(TermFB,TermXo,TermYo,"  0: 2-monitor mode, normal");
		MyTextOut(TermFB,TermXo,TermYo,"  1: 1-monitor mode, swap Menu and Canvas");
		MyTextOut(TermFB,TermXo,TermYo,"  2: 1-monitor mode, overlay Menu on Canvas");
		MyTextOut(TermFB,TermXo,TermYo,"  3: 1-monitor mode, no Menu, 8-bit GetPic");
		MyTextOut(TermFB,TermXo,TermYo,"> ");
		MyTypein(TermFB,&s); if (strlen(s)>0) i = atoi(s); 
		if (i<=3) { SPMode = i; }
		else { MyTextOut(TermFB,-1,-1,"  Error, using SPMode=0"); }
	}

//	MyTextOut(TermFB,TermXo,TermYo,CmdLine);
	MyTextOut(TermFB,TermXo,TermYo,"SuperPaint'78 starting...");
	if (SPMode>=0) MyTextOut(TermFB,-1,-1,modestr[SPMode]);

	MyTests();

	return 0;
}


int FindFB(HWND wnd) {	/* find FB associated with a window */
	int i;				/* surely there's a better way... */
	for (i=0; i<nFB; i++) {
		if (FB[i].wnd == wnd) return i;
	}
	return -1;
}


void MyUpdate(int fb) {		/* refresh main FBs */
	int i, i0=0, i1=1;

	if (fb >= 0) i0 = i1 = fb;
	for (i=i0; i<=i1; i++) 
		MyInvalidate(i,FB[i].x,FB[i].y,FB[i].w,FB[i].h);
}

void MyInvalidate(int fb, int x, int y, int w, int h) {
	int xx,yy,yFirst,yLast,xFirst,xLast,fbout=fb;
	RECT r;
	byte *pp, v;
	__int32 i;	/* need all 32 bits! */

	SetDIBColorTable(FB[MenuFB].dc, 0, nMColors, MyCMap);	// both get same table
	SetDIBColorTable(FB[CanvFB].dc, 0, nMColors, MyCMap);

	if (x<0) {							/* default full win */
		x=FB[fb].x; y=FB[fb].y; w=FB[fb].w; h=FB[fb].h; }

	if (fb <= CanvFB) {		/* don't refresh terminal or Go window */
		yFirst = max(y,0);
		yLast = min(y+h,FB[fb].h); yLast = min(yLast,FBHeight);
		xFirst = max(x,0);
		xLast = min(x+w,FB[fb].w); xLast = min(xLast,FBWidth);

		if (SPMode>0) fbout = CanvFB;	/* Swap or Overlay Mode, use Canvas */
		pp = FB[fbout].pFBbm;			/* ptr to the bitmap */

		for (yy=yFirst; yy<yLast; yy++) {
			xx = xFirst;
			i = ((FB[fbout].h-1-yy)*FB[fbout].w + xx);
			for (; xx<xLast; xx++) {
				v = MyPix[yy][xx];
				if (CMapMode&004 || (SPMode==0 && fb==0)) v >>= 4;
				if (CMapMode&010) v &= 0xf;
				pp[i++] = v;
			}
		}
	}

	r.left = x;
	r.right = x+w;
	r.top = y;
	r.bottom = y+h;
	InvalidateRect(FB[fbout].wnd, &r, 0);
	UpdateWindow(FB[fbout].wnd);		/* display it */
}


void SetFBFocus(int fb) {
	resovly(); MyUpdate(Focfb);
	if (SPMode==0) {				/* 2-monitor mode */
		BringWindowToTop(FB[fb].wnd);
		if (fb==MenuFB) BringWindowToTop(FB[TermFB].wnd);
		if (fb==CanvFB) BringWindowToTop(FB[GoDfFB].wnd);
		ShowWindow(FB[fb].wnd, SW_SHOW);
	}
	Focfb = fb; 
	MyUpdate(Focfb);
}


void MyFinish() {
	PostQuitMessage(0);
}


int curX=TermXo, curY=TermYo;	/* current text pos */
char TypeinS[256];		/* typein buffer */
int TypeinFB = TermFB;	/* typein fb */
int Typein = 0;			/* -1 awaiting typein, 0 empty, 1 full/ready */

void MyTextOut(int fb, int x, int y, char *s) {		/* string to window */
	if (x >= 0 && fb==TermFB) ScrollText(fb);
	else { x = curX; y = curY; }
	SetTextAlign(FB[fb].dc, TA_BASELINE|TA_NOUPDATECP);	
	TextOut(FB[fb].dc,x,FB[fb].h-1-y,s,strlen(s));
	curX = x + 8*strlen(s); curY = y;
	MyInvalidate(fb,-1,0,0,0);
}

void ScrollText(fb) {						/* scroll terminal window */
	int i;

	for (i=0; i<16; i++) {
		BitBlt(FB[fb].dc,0,0,FB[fb].w,FB[fb].h-1,FB[fb].dc,0,1,SRCCOPY);
		MyInvalidate(fb,-1,0,0,0);		/* slow it down */
		MyInvalidate(fb,-1,0,0,0);
		MyInvalidate(fb,-1,0,0,0);
		MyInvalidate(fb,-1,0,0,0);
	}
}

void MyTypein(int fb, char *s) {		/* typein in window */
	Typein = -1; TypeinFB = fb;
	while (Typein<0) MyUpdate(fb);
	strcpy(s, TypeinS); Typein = 0; TypeinS[0] = 0;
	if (fb==TermFB && s[0]==0) ScrollText(fb);
}


void MyRect(int fb,int x,int y,int w,int h) { /* filled rect */
	HDC dc = FB[fb].dc;					/* special, write window pixels */
	Rectangle(FB[fb].dc,x,y,x+w-1,y+h-1);
	MyInvalidate(fb,x,y,w,h);
}


void SetTabPos(HWND hWnd, LPARAM lParam) {	/* set tablet position from mouse */
	TXPos = LOWORD(lParam);
	TYPos = HIWORD(lParam);
	Tfb = FindFB(hWnd);
	if (Tfb==GoDfFB) {			// if in Go/Default area
		TXPos += FBWidth;		// appear as if on right of tablet
		Tfb = CanvFB;			// and on Canvas
	}
	else if (SPMode>0 && Tfb<=CanvFB) Tfb = Focfb;
}


LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT	ps;
	HDC winDC;
	int l, t, r, b; char s[100]; int x,y; byte v,vr,vg,vb;

	switch (message) {
		case WM_GETMINMAXINFO:
			((MINMAXINFO*)lParam)->ptMinTrackSize.x = 0;	// ??
			return 0;
		case WM_CHAR:
			if (Typein<0) {		/* awaiting typein */
				if (wParam == '\x0d') Typein = 1;		/* CR, done */
				else {
					s[0] = (char)wParam; s[1] = 0;
					MyTextOut(TypeinFB,-1,-1,s);		/* echo it */
					MyInvalidate(TypeinFB,-1,0,0,0);
					strncat(TypeinS, s, 1);	
				}
				break;
			} 
			switch (wParam) {
				case 'r':			/* ramps */
					RampPix(); 
					MyUpdate(-1);
					break;
				case 'c':			/* colors */
					RampColors();
					MyUpdate(-1);
					break;
				case 't':
					break;
				case '\x1b':		/* escape */
				case 'q':			/* quit */
				case 'x':			/* exit */
					PostQuitMessage(0);
					break;
			}
			break;
		case WM_LBUTTONDOWN:
 			EnterCriticalSection(&EvLock);
				LbDown = 1; 
				SetTabPos(hWnd, lParam);
			LeaveCriticalSection(&EvLock);
			break;
		case WM_LBUTTONUP:
			EnterCriticalSection(&EvLock);
				LbDown = 0; 
				SetTabPos(hWnd, lParam);
			LeaveCriticalSection(&EvLock);
			break;
		case WM_RBUTTONDOWN:
			EnterCriticalSection(&EvLock);
				RbDown = 1; 
				SetTabPos(hWnd, lParam);
			LeaveCriticalSection(&EvLock);
			if (Tfb>1) break;
			x = TXPos; y = FB[Tfb].h-1-TYPos;
			RdFBPix(0xf000,x,y,&v);		// BOTHQ
			vr = MyCMap[v].rgbRed;
			vg = MyCMap[v].rgbGreen;
			vb = MyCMap[v].rgbBlue;
			sprintf(s,"%d : %d, %d : %d (%d,%d,%d)",Tfb,x,y,v,vr,vg,vb);
			MyTextOut(TermFB,10,6,s);
			MyInvalidate(TermFB,-1,0,0,0);
			break;
		case WM_RBUTTONUP:
			EnterCriticalSection(&EvLock);
				RbDown = 0; 
				SetTabPos(hWnd, lParam);
			LeaveCriticalSection(&EvLock);
			break;
		case WM_MOUSEMOVE:
 			EnterCriticalSection(&EvLock);
				SetTabPos(hWnd, lParam);
			LeaveCriticalSection(&EvLock);
			SetCursor((Focfb==Tfb&&(TXPos<FBWidth))?NULL:HCurs);
			break;
		case WM_PAINT:
			winDC = BeginPaint(hWnd, &ps);
			SelectObject(winDC, GetStockObject(NULL_PEN));
			SelectObject(winDC, GetStockObject(BLACK_BRUSH));
			l = ps.rcPaint.left;
			t = ps.rcPaint.top;
			r = ps.rcPaint.right;
			b = ps.rcPaint.bottom;
			BitBlt(winDC, l, t, r-l, b-t, FB[FindFB(hWnd)].dc, l, t, SRCCOPY);
			EndPaint(hWnd, &ps);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return(0);
}



BOOL CALLBACK DlgProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam) 
{ 
	int val; 

    switch (message) 
    { 
 
		case WM_INITDIALOG: 
			CheckRadioButton(hwndDlg, IDC_RADIO1, IDC_RADIO4, IDC_RADIO1);
			return TRUE; 
		case BN_CLICKED:
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK: 
					if (IsDlgButtonChecked(hwndDlg, IDC_RADIO1)) val = 0;
					else if (IsDlgButtonChecked(hwndDlg, IDC_RADIO2)) val = 1;
					else if (IsDlgButtonChecked(hwndDlg, IDC_RADIO3)) val = 2;
					else if (IsDlgButtonChecked(hwndDlg, IDC_RADIO4)) val = 3;
					else { val = 0; }	// ??
					EndDialog(hwndDlg,val); 
					return TRUE;
				case IDCANCEL: 
					EndDialog(hwndDlg,-1); 
					return TRUE;
			}
 
        default: 
            return FALSE; 
    } 
}


void InitD(winDC,x,y,w,h,dib,p)
	HDC winDC; pane *p;
	int x,y,w,h,dib;
{
	HBITMAP hBitmap;
	BITMAPINFO bmi;
	p->dc  = CreateCompatibleDC(winDC);
	if (dib) {
		bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bmi.bmiHeader.biWidth = w;
		bmi.bmiHeader.biHeight = h;
		bmi.bmiHeader.biPlanes = 1;
		bmi.bmiHeader.biBitCount = 8;
		bmi.bmiHeader.biCompression = BI_RGB;
		bmi.bmiHeader.biSizeImage = 0;
		bmi.bmiHeader.biXPelsPerMeter = 0; 
		bmi.bmiHeader.biYPelsPerMeter = 0; 
 		bmi.bmiHeader.biClrUsed = 0; 
		bmi.bmiHeader.biClrImportant = 0;
		hBitmap = CreateDIBSection(winDC, &bmi, DIB_PAL_COLORS, &p->pFBbm, NULL, 0);
	} else
		hBitmap = CreateCompatibleBitmap(winDC, w, h);
	SelectObject (p->dc, hBitmap);
	p->x = x; p->y = y; p->w = w; p->h = h;
}


int InitFB(int spmode, HINSTANCE hInstance) {	// set up frame buffers, windows, etc
	HDC winDC, dc;
	LPVOID lpParam=NULL;
	int Screenw, Screenh, Winw, Winh, Gow, Goh, x, y, i;

	Screenw = GetSystemMetrics(SM_CXFULLSCREEN);
	Screenh = GetSystemMetrics(SM_CYFULLSCREEN);

	Winw = FBWidth+6; Winh = FBHeight+25;	// FB win size including border 
	Gow = 68; Goh = FBHeight+25;			// Go/Default win size

											// Menu
	FB[MenuFB].wnd = CreateWindow(appName, winName[MenuFB], WS_BORDER, 0, 0, 
		Winw, Winh, NULL, NULL, hInstance, lpParam);
	if (!FB[MenuFB].wnd) { return FALSE; }  

											// Canvas
	if (spmode==0) { x = Screenw-Winw-Gow; y = Screenh-Winh+19; }	// lower right
	else { x = (Screenw-Winw)/2; y = (Screenh-Winh)/2; }			// centered
	FB[CanvFB].wnd = CreateWindow(appName, winName[CanvFB], WS_BORDER, x, y, 
		Winw, Winh, NULL, NULL, hInstance, lpParam);
	if (!FB[CanvFB].wnd) { return FALSE; }   

											// Go/Default - to right of Canvas
	FB[GoDfFB].wnd = CreateWindow(appName, winName[GoDfFB], WS_BORDER, x+Winw, y, 
		Gow, Goh, NULL, NULL, hInstance, lpParam);
	if (!FB[GoDfFB].wnd) { return FALSE; }    
	
											// Terminal
	if (spmode==0) { x = 0; y = Winh; }		// below Menu
	else { y = y+Winh; }					// below Canvas
	FB[TermFB].wnd = CreateWindow(appName, winName[TermFB], WS_BORDER, x, y, 
		Winw, TermHeight+25, NULL, NULL, hInstance, lpParam);
	if (!FB[TermFB].wnd) { return FALSE; }    
	
	winDC = GetWindowDC(FB[MenuFB].wnd);	
	InitD(winDC,0,0,FBWidth,FBHeight,1,&FB[MenuFB]);
	dc = FB[MenuFB].dc;
	SelectObject(dc, GetStockObject(NULL_PEN));
	SelectObject(dc, GetStockObject(WHITE_BRUSH));
	SelectObject(dc, GetStockObject(SYSTEM_FIXED_FONT));
	SetDIBColorTable(dc, 0, nMColors, MyCMap);
	ReleaseDC(FB[MenuFB].wnd,winDC);

	winDC = GetWindowDC(FB[CanvFB].wnd);	
	InitD(winDC,0,0,FBWidth,FBHeight,1,&FB[CanvFB]);
	dc = FB[CanvFB].dc;
	SelectObject(dc, GetStockObject(NULL_PEN));
	SelectObject(dc, GetStockObject(GRAY_BRUSH));
	SelectObject(dc, GetStockObject(SYSTEM_FIXED_FONT));
	SetDIBColorTable(dc, 0, nMColors, MyCMap);
	ReleaseDC(FB[CanvFB].wnd,winDC);

	winDC = GetWindowDC(FB[GoDfFB].wnd);	
	InitD(winDC,0,0,Gow,Goh,1,&FB[GoDfFB]);
	dc = FB[GoDfFB].dc;
	SelectObject(dc, GetStockObject(NULL_PEN));
	SelectObject(dc, GetStockObject(GRAY_BRUSH));
	SelectObject(dc, GetStockObject(SYSTEM_FIXED_FONT));
	SetBkColor(dc, RGB(0,0,0));
	SetTextColor(dc, RGB(128,128,128));
	SetBkMode(dc, TRANSPARENT);
	Rectangle(dc,0,FBHeight-80,Gow,FBHeight-77);
	TextOut(dc,26,200,"GO",2);
	TextOut(dc,4,436,"DEFAULT",7);
		MyCMap[0].rgbRed = 224;
		MyCMap[0].rgbGreen = 224;
		MyCMap[0].rgbBlue = 224;
	for (i=1; i<nMColors; i++) {
		MyCMap[i].rgbRed = i;
		MyCMap[i].rgbGreen = i;
		MyCMap[i].rgbBlue = i;
	}
	SetDIBColorTable(dc,0,nMColors,MyCMap);
	ReleaseDC(FB[GoDfFB].wnd,winDC);

	winDC = GetWindowDC(FB[TermFB].wnd);	
	InitD(winDC,0,0,FBWidth,TermHeight,1,&FB[TermFB]); 
	dc = FB[TermFB].dc;
	SelectObject(dc, GetStockObject(NULL_PEN));
	SelectObject(dc, GetStockObject(BLACK_BRUSH));
	SelectObject(dc, GetStockObject(SYSTEM_FIXED_FONT));
	SetBkColor(dc, RGB(0,0,0));
	SetTextColor(dc, RGB(128,128,128));
	SetBkMode(dc, OPAQUE);
	for (i=0; i<nMColors; i++) {
		MyCMap[i].rgbRed = i;
		MyCMap[i].rgbGreen = i;
		MyCMap[i].rgbBlue = i;
	}
	SetDIBColorTable(dc, 0, nMColors, MyCMap);
	ReleaseDC(FB[TermFB].wnd,winDC);

	MyRect(MenuFB,0,0,FBWidth,FBHeight);		/* clear Menu */
	MyRect(CanvFB,0,0,FBWidth,FBHeight);		/* clear Canvas */
//	MyRect(GoDfFB,0,0,Gow,Goh);					/* clear Go/Default */
	MyRect(TermFB,0,0,FBWidth,TermHeight);		/* clear Terminal */

	if (spmode==0) 
		ShowWindow(FB[MenuFB].wnd, SW_SHOWNORMAL);
	ShowWindow(FB[CanvFB].wnd, SW_SHOWNORMAL);
	if (spmode<3) {
		ShowWindow(FB[GoDfFB].wnd, SW_SHOWNORMAL);
		UpdateWindow(FB[GoDfFB].wnd); }
	ShowWindow(FB[TermFB].wnd, SW_SHOWNORMAL);
	UpdateWindow(FB[TermFB].wnd);
	
	return TRUE;
}


int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASS	wc;
	DWORD	threadId;
	MSG		mesg;
	ATOM	myClass;

	strcpy(CmdLine,lpCmdLine);		// save the command line

	SPMode = DialogBox(hInstance, MAKEINTRESOURCE(SPModeDialog), NULL, (DLGPROC)DlgProc);
	if (SPMode<0) return (0);			// punt

	CMapMode = 0;		// Q0 & Q1

	InitializeCriticalSection(&EvLock);			// mutex for tablet

	if (!hPrevInstance) {						// set up callback
		wc.style = CS_VREDRAW | CS_HREDRAW;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.lpfnWndProc = (WNDPROC)WndProc;
		wc.hInstance = hInstance;
		wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
		wc.hCursor = NULL;
		wc.hbrBackground = NULL;
		wc.lpszMenuName =  NULL;
		wc.lpszClassName = appName;
		myClass = RegisterClass(&wc);
		if (myClass==0) { return(0); }
	}

	HCurs = LoadCursor(NULL, IDC_CROSS);			// default cursor

	if (!InitFB(SPMode, hInstance)) return FALSE;	// set up the fbs, windows, etc

	Thread = CreateThread(							// run the program
		NULL,				/* default security */
		0,					/* same stack size as parent */
		(LPTHREAD_START_ROUTINE) MyMain,	/* start of program */
		0,					/* (unused) arg */
		0,					/* create it running */
		&threadId);
	LbDownEv = CreateEvent(
		0,					/* default security */
		0,					/* autoReset */
		0,					/* initialState = non-signalled */
		"");				/* No name */

	/* Main message loop: */
	while (GetMessage(&mesg, NULL, 0, 0)) {
		TranslateMessage(&mesg);	/* so we get WM_CHAR */
		DispatchMessage(&mesg);
	}
	return (mesg.wParam);
} 


