
                        		// SPB.BCPL - SUPERPAINT B

			//** Translated roughly from BCPL by bcpl2c.pl, 10/4/2005
                            		// 1/21/75 RGS
                            		// modified October 6, 1978 RGS

#include "G06DEFS.H"
#include "IOX.H"
#include "FREEDEFS.H"
#include "SPDEFS.H"

int CYSPEED;		// -CYSPEEDMAX TO + CYSPEEDMAX,
                		//    FAST BACKWARD TO FAST FORWARD
int CYCOUNT;		// COUNTS DOWN FROM
                		//    CYSPEEDMAX-ABSVAL(CYSPEED) TO 0
int CYRUNSW;		// TRUE IF CYCLING
int CYMODE;			// 0 - NO CYCLING
                    		// 1 - CY COLORS
                    		// 2 - ALT COLORS
                    		// 3 - ALT COLORS, HOLD ON
                    		// -1 - SETTING ALT COLORS
int CYNUM;			// NUMBER OF CURRENT ALT COLOR
                    		//    OR CURRENT CYCLING COLOR
COLOR *MCMAP;		// MAIN COLOR MAP
COLOR *ALTCMAP;		// ALTERNATE COLOR MAP



void SPB_PROG() { }


void WUP()		// wait until pen up
  {
   POS P; PENSTAT S;
   do READTABLET(&P,&S); while (S.DOWN);
         }


void RESPIC(RESCOLORS) 
  {
	int I;

   WRITEFORM(2,0,"GET PICTURE ",0,RESCOLORS?"+ COLORTABLE":"(NO COLORS)");
   TABGRID = GRID; CYMODE = 0;
   GETPIC(9,Q1,(RESCOLORS ? 2:0),ALTCMAP,0,TRUE,FALSE,FALSE,&CYMODE,&CYSPEED);
   READCOLORMAP(MCMAP,16);
   for (I=0; I<=63; I++) ((word*)MCMAP)[I] = ((word*)MCMAP)[I] & COLORPRIMASK;
   SETCOLORMAP(MCMAP,16);
   CYRUNSW = FALSE;
   if (SWITCHES[14] != 0) COLORFIX();
   DISPBRUSHES();
   SETPALSEL();
         }

void PAINT(SW) 
 {/*PAINT*/ 
   POS P; PENSTAT S; COLOR C[16];

   if (SW) WRITEFORM(1,0,"PAINT");
   WUP(); TABGRID = 0;

  do {/*LOOP*/ 
   READTABLET(&P,&S);
   if (S.PROX)
      switch (FINDMENU(P,DEFMENU,DEFMENULEN)) {/*C*/ 
          case 0: if (S.PUSH) { goto L1; }
          case 1: if (S.PUSH) { CYRUNSW = !CYRUNSW; goto L1; }
          case 2:
				SETVALTRANSTAB(2,TRANSPARENT,-1);
				SETVALTRANSTAB(2,BRUSHVAL,PAINTVAL);
				BRWIN[BR]->XORIG = P.X; BRWIN[BR]->YORIG = P.Y;
				RUNTABSTOPM(5,*BRWIN[BR],BRRUNTABS[BR],BRNUMTABS[BR],(SW && S.DOWN ? Q1:OVQ1),BRXTABS[BR]);
				SETVALTRANSTAB(1,TRANSPARENT);
				SETVALTRANSTAB(2,BRUSHVAL,BRUSHVAL);
				if (CYRUNSW) { CYMAP(&C); SETCOLORMAP(&C,16); }
				if ((CYMODE == 1) && (PAINTVAL > 5))
							PAINTVAL = (PAINTVAL <= 6 ? 15:PAINTVAL-1);
		  default: break;
      }/*C*/ 

   if (CYRUNSW) {
      CYMAP(&C);
      PMVIWAIT(2);
      SETCOLORMAP(&C,16); 
	}
                }/*LOOP*/ while (1);

L1: 
   if (CYMODE > 0) SETCOLORMAP(MCMAP,16);
   INITCY();
   if (SWITCHES[14] != 0) COLORFIX();
   SETPALSEL();
                   }/*PAINT*/ 


void PALHIT(POS P) {
   POS P1; COLOR C; int MODE = Q0;
   word M[] = { PALPXO, PALPYO, PALPW, PALPH };

   switch (FINDMENU(P,M,1)) 
     { case 0: SETPIC(1);
         MODE = Q1;
         TABGRID = 0;
         TABLETSTROKE(4,&P,&P1,OVQ1,OVQ1);
         switch (FINDMENU(P,DEFMENU,DEFMENULEN)) 
           { default:
             case 0:
             case 1: return; break;
             case 2: break;
                        }
       default: break;  }

   PTWIN->YORIG = P.Y;
   PTWIN->XORIG = P.X;
   PMTORUNTABS(4,*PTWIN,PTRUN,1,MODE);
   PAINTVAL = PTRUN[0].VALUE;
//   if (MODE == Q0) PAINTVAL = PAINTVAL >> 4;  // REMOVE LATER
   SETPIC(0);
   C.VALUE = PAINTVAL; READCOLORMAP(&C,1);		// 9/05 rgs
   WRITEFORM(7,0,"COLOR #",10,C.VALUE,0,"(",10,C.RED,10,C.GREEN,10,C.BLUE,0,")");	//
   DISPBRUSHES();
   SETPALSEL();
                }


void SETPALSEL() 
 {/*SP*/ 
   POS APOS; COLOR C;

   APOS.Y = PALWIN->YORIG;
   APOS.X = PALWIN->XORIG-5 + (17-PAINTVAL)*PALCW;
   MENUARROW(2,APOS,*PALWIN);

   C.VALUE = PAINTVAL;
   READCOLORMAP(&C,1);
   if (SLIDHSBR) RGBTOHSBR(&C,&C);
   // WRITEFORM(8,0,"*N",8,C!0,0," ",8,C!1,0," ",8,C!2,0," ",8,C!3)
   SETSLIDERS(C);
             }/*SP*/ 


void SELBRUSH(POS P) 
 {/*SEL*/ 
   BR = (P.X-BRUSHWIN->XORIG)/BRUSHW;
   SETBRUSHSEL();
         }/*SEL*/ 


void SETBRUSHSEL() {
   POS P;
   P.Y = BRUSHWIN->YORIG;
   P.X = BRUSHWIN->XORIG + BR*BRUSHW + BRUSHW/2;
   MENUARROW(2,P,*BRUSHWIN);
}


void MENUARROW(int N, POS P, WIN WN) {
	WIN WT, *pW=&WN;
	switch (N) {
        case 1: pW = 0;
        case 2: break;
        default: ERROR(2,"MENUARROW",0); };

      if (pW != 0) {          		// CLEAR AREA BELOW WIN
        pW = &WT;
        FILLWIN(7,pW,WN.XORIG,WN.YORIG,WN.W,ARROWWIN->H,0,ARROWWIN->YOFF);
        CLEARPM(3,TRANSPARENT,*pW,Q0); };

      ARROWWIN->YORIG = P.Y;
      ARROWWIN->XORIG = P.X;
      SETVALTRANSTAB(2,TRANSPARENT,-1);
      SETPMCONFIG(2,0,2);
      RUNTABSTOPM(4,*ARROWWIN,ARROWRUNTABS,ARROWNTABS,Q0);
      SETPMCONFIG(2,0,0);
      SETVALTRANSTAB(1,TRANSPARENT);
                             }


 void SETSLIDERS(COLOR C) 
     {
      POS NEWP; WIN W;

      FILLWIN(7,&W,SLIDWIN->XORIG,0,SLIDWIN->W,0,0,0);
      if (((word*)&C)[1] != SLIDERV[1])
       {  NEWP.Y = SLID1Y;
          NEWP.X = SLIDERXL + (((word*)&C)[1] << 1);
          W.YORIG = SLID1Y;
          MENUARROW(2,NEWP,W);
          SLIDERV[1] = ((word*)&C)[1];
                     }
      if (((word*)&C)[2] != SLIDERV[2])
       {  NEWP.Y = SLID2Y;
          NEWP.X = SLIDERXL + (((word*)&C)[2] << 1);
          W.YORIG = SLID2Y;
          MENUARROW(2,NEWP,W);
          SLIDERV[2] = ((word*)&C)[2];
                     }
      if (((word*)&C)[3] != SLIDERV[3])
       {  NEWP.Y = SLID3Y;
          NEWP.X = SLIDERXL + (((word*)&C)[3] << 1);
          W.YORIG = SLID3Y;
          MENUARROW(2,NEWP,W);
          SLIDERV[3] = ((word*)&C)[3];
                     }
     }


 void SLIDERHIT(POS P) 
 {
     COLOR C; PENSTAT S; word I,J, *T;

     I = (3*(SLIDYO + SLIDH-P.Y))/SLIDH + 1;
     I = (I > 3 ? 3:I);
     TABGRID=0;

   do {/*L*/ 
     ((word*)&C)[0] = PAINTVAL;
     ((word*)&C)[1] = SLIDERV[1];
     ((word*)&C)[2] = SLIDERV[2];
     ((word*)&C)[3] = SLIDERV[3];

   ((word*)&C)[I] = CHECKMINMAX(P.X-SLIDERXL,0,511) >> 1;
   SETSLIDERS(C);
   if (SLIDHSBR) HSBRTORGB(&C,&C);
   PMVIWAIT(1);
   SETCOLORMAP(&C,1);
   if ((SWITCHES[14] != 0) && (PAINTVAL != 0))
       for (J=0; J<=15; J++) {
           ((word*)&C)[0]= 16*PAINTVAL+J;
           SETCOLORMAP(&C,1);  }
   if (CYMODE != -1) {
       T = (word*)MCMAP + 4*PAINTVAL;
       T[1] = ((word*)&C)[1]; T[2] = ((word*)&C)[2]; T[3] = ((word*)&C)[3]; }
   READTABLET(&P,&S);
   }/*L*/ while (S.DOWN);
 }


void SLIDLABEL() 
  {
	FILE *CH; COLOR C;

   SLIDHSBR = !SLIDHSBR;
   CH = OPEN(SLIDHSBR ? "HSB.PA":"RGB.PA");
   if (CH) {
	PAFTOPM(4,CH,0,Q0,0);
	CLOSE(CH);
   }
   C.VALUE = PAINTVAL;
   READCOLORMAP(&C,1);
   if (SLIDHSBR) RGBTOHSBR(&C,&C);
   SETSLIDERS(C);
           }


void MENUBOXES(word *MENU, int MENULEN) 
  {
   WIN W; int I,J; word *M;

   for (I=0; I<=MENULEN-1; I++)
     {
       M = MENU + 4*I;
       FILLWIN(7,&W,M[0],M[1],M[2],M[3],0,0);
       for (J=1; J<=10; J++) CLEARPM(3,BRUSHVAL,W,OVQ0);
     }
  }


void FILL() {
   POS P, P1;

   WRITEFORM(1,0,"AREA FILL");
   TABGRID = 0;
   do {/*L*/ 
       WRITEFORM(1,0,"TOUCH A POINT IN THE AREA TO BE FILLED");
       TABLETSTROKE(4,&P,&P1,OVQ1,OVQ1);
       switch (FINDMENU(P,DEFMENU,DEFMENULEN)) 
         { default:
           case 0:
           case 1: return;
           case 2: break;
                     }
       SFILL(3,P,PAINTVAL,Q1); }/*L*/ while (1);
	}


void SETGRID() {
   char S[20];

   GRID = -GRID;
   if (GRID < 0) { WRITEFORM(1,0,"GRIDDING OFF"); }
   else { WRITEFORM(1,0,"SET GRIDDING");   
	WRITEFORM(1,0,"TYPE ANY NUMBER, CR");
	WRITEFORM(3,0," (CR ALONE => USE PREVIOUS GRID = ",10,GRID,0,")");
	TTYWAIT(2,"GRID SPACING: ",&S);
	if ((S[0] && RMASK) == 015) return;		// CR
    else GRID = STRTOVALUE(S,10);
   }
}


