/**********************************************************************
* File: data.c
* File $Revision: 3.1 $
* $Date: 1991/01/21 16:28:35 $
*	Copyright (C) 1990 by Applied Microsystems Corp.
*
* DESC:	Data Manipulation Functions
***********************************************************************
**                    Include Header Information                     **
**********************************************************************/

#include "cdemon.h"

/**********************************************************************
**                     Data Structures & Arrays                      **
**********************************************************************/

struct card		/* structure with bit fields */
    {		        /* 15 ---- 8 7 ----- 0 Bits */
    WORD pad      : 8;  /* ____ ____ 1000 XXXX = Pad */
    WORD spades   : 1;  /* XXXX XXXX 1000 XXXX = Spades */
    WORD hearts   : 1;  /* XXXX XXXX 0100 XXXX = Hearts */
    WORD diamonds : 1;  /* XXXX XXXX 0010 XXXX = Diamonds */
    WORD clubs    : 1;  /* XXXX XXXX 0001 XXXX = Clubs */
    WORD count    : 4;  /* XXXX XXXX XXXX ____ = counting value */
    };

struct player           /* simple structure */
    {
    char name[10];		/* player name */
    struct card cards[5];	/* array of cards */
    int  points;		/* total points of cards */
    int  dealt;			/* number of cards in array */
    };

union poker		/* union with multiple types of arrays */
    {
    WORD unsort[4][13];	/* for use while sorting cards into */
    WORD sorted[2][26];	/* the proper suit and count value  */
    WORD shuffled[52];	/* for use while shuffling */
    struct card cards[52];	/* for use when evaluating card */
    } deck;

struct player players[4]; 
struct player dealer;
struct card *card_ptr;

WORD hand[52];
WORD *hand_ptr;

int suit, count, pass;
int i, j, k, n, forever=1;

/**********************************************************************
**                     Data Manipulation Functions                   **
**********************************************************************/

data()
    {
    init();	/* initialize players and dealer structures */
    sort();	/* sort the deck according to suit and count */
    shuffle();	/* shuffle deck three times */
    deal();	/* deal one card to everyone */
    hit();	/* deal additional cards to players */
    house();	/* deal additional cards to dealer */
    }

/**********************************************************************
**
**  init() - Initialize players and dealer structures function
**
**	This function sets the number of cards dealt and point values
**  for each player and the dealer to zero.  The name of each player
**  is initialized including the dealer.  
*/
init()
    {
    for (i = 0;i < 4;i++)
        {
        players[i].points = 0;
        players[i].dealt = 0;
	}
    dealer.points = 0;
    dealer.dealt = 0;

    strcpy(dealer.name,"brian");
    strcpy(players[0].name,"john");
    strcpy(players[1].name,"paul");
    strcpy(players[2].name,"george");
    strcpy(players[3].name,"ringo");
    }

/**********************************************************************
**
**  sort() - Sort the deck according to suit and count function
**
**	This function sets up a block of memory as a deck of cards by
**  initializing 52 words to the appropriate bit field values in the
**  structure card.
*/
sort()
    {
    for (suit = 0;suit < 4;suit++)	/* do for each suit value */
        {
	for (count = 0;count < 13;count++) /* do each count value */
            {
	    deck.unsort[suit][count] = ((CLUBS << suit)|(count + 1));
	    }
	}
    }

/**********************************************************************
**
**  shuffle() - shuffle deck three times
**
**	This function divides the deck, 52 words of memory, into two
**  hands and then by alternating between the two hands in a pseudo
**  random process recombines them back into one deck.
*/
shuffle()
    {
    for (pass = 0;pass < 3;pass++)  /* 3 pass shuffle */
        {
	i = 0 ; j = 0 ; k = 0 ; hand_ptr = &deck.shuffled[0];
        while (i < 52)      /* do until all cards are shuffled */
            {
	    if (*hand_ptr++ & PARITY) /* alternate between piles */
		{
                if (j < 26) hand[i++] = deck.sorted[0][j++]; /* pile 1 */
		}
	    else
		{
                if (k < 26) hand[i++] = deck.sorted[1][k++]; /* pile 2 */
		}
	    }
        for (i = 0;i < 52;i++)	     /* put hand back as shuffled deck */
	    deck.shuffled[i] = hand[i];
	}
    }

/**********************************************************************
**
**  deal() - Deal one card to everyone
**
**	This function deals one card to each player including the
**  dealer.  The dealt field for each player is set to one.
*/
deal()
    {
    card_ptr = &deck.cards[0];		/* init card pointer */
    for (i = 0;i < 4;i++)		/* one to all players */
	players[i].cards[players[i].dealt++] = *card_ptr++;
					/* including the dealer */
    dealer.cards[dealer.dealt++] = *card_ptr++;
    }

/**********************************************************************
**
**  hit() - Deal additional cards as needed to players
**
**	This function starts by dealing one additional card to a
**  player.  If the points for that player are less than 18 then
**  another card is dealt until either the players hand exceeds
**  17 points or 5 cards are dealt.  This process is repeated for
**  each player.
*/
hit()
    {
    for (i = 0;i < 4;i++)	/* to all players */
	{
	do
	    {		/* draw another card */
	    players[i].cards[players[i].dealt++] = *card_ptr++;
			/* add up players points */
	    players[i].points = 0;		/* zero out points */
	    for (j = 0; j < players[i].dealt; j++) /* add up cards */
	        {
	        hand_ptr = (WORD *)&players[i].cards[j];
	        switch (*hand_ptr & COUNT) 
		    {
		    case 1:	/* ACE */
		        players[i].points += (players[i].points < 11) ? 11 : 1;
		        break;
		    case 2:	/* DEUCE */
		    case 3:	/* THREE */
		    case 4:	/* FOUR */
		    case 5:	/* FIVE */
		    case 6:	/* SIX */
		    case 7:	/* SEVEN */
		    case 8:	/* EIGHT */
		    case 9:	/* NONE */
		        players[i].points += *hand_ptr & COUNT;
		        break;
		    case 10:	/* TEN */
		    case 11:	/* JACK */
		    case 12:	/* QUEEN */
		    case 13:	/* KING */
		        players[i].points += 10;
		        break;
		    }
	        }
	    } while ((players[i].points < 18)&&(players[i].dealt < 5));
	}
    }

/**********************************************************************
**
** house() - deal additional cards as needed to the dealer
**
**	This function starts by dealing one additional card to the
**  dealer.  If the points for the dealer are less than 18 then
**  another card is dealt until either the dealers hand exceeds
**  17 points or 5 cards are dealt.
*/
house()
    {
    do
	{	/* draw another card */
	dealer.cards[dealer.dealt++] = *card_ptr++;
		/* add up dealer points */
	dealer.points = 0;		/* zero out points */
	for (j = 0; j < dealer.dealt; j++) /* add up cards */
	    {
	    hand_ptr = (WORD *)&dealer.cards[j];
	    switch (*hand_ptr & COUNT) 
		{
		case 1:	/* ACE */
		    dealer.points += (dealer.points < 11) ? 11 : 1;
		    break;
		case 2:	/* DEUCE */
		case 3:	/* THREE */
		case 4:	/* FOUR */
		case 5:	/* FIVE */
		case 6:	/* SIX */
		case 7:	/* SEVEN */
		case 8:	/* EIGHT */
		case 9:	/* NONE */
		    dealer.points += *hand_ptr & COUNT;
		    break;
		case 10:	/* TEN */
		case 11:	/* JACK */
		case 12:	/* QUEEN */
		case 13:	/* KING */
		    dealer.points += 10;
		    break;
		}
	    }
	} while (dealer.points < 18);
    }

/*********************************************************************
**                     End of Data Functions                        **
*********************************************************************/

