// SX_GPIO_Demo_eVCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SX_GPIO_Demo_eVC.h"
#include "SX_GPIO_Demo_eVCDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAX_ASCII_LENGTH 2

extern "C" _declspec(dllimport) void SetPortDir(int nPort, BYTE dbDir);
extern "C" _declspec(dllimport) BYTE GetPortDir(int nPort);
extern "C" _declspec(dllimport) BYTE ReadPort(int nPort);
extern "C" _declspec(dllimport) void WritePort(int nPort,BYTE dbValue);

int data_mark=0;

int Ascii2Hex(char *p)
{
    if((*p>='0') && (*p<='9'))
	{
		return (*p -0x30);

	}
	if((*p>='A') && (*p<='F'))
	{
	return	(*p- 'A' + 0xa);

	}
	if(*p>='a' && *p<='f')
	{
	   return (*p - 'a' + 0xa);
	}
	return -1;
}
/////////////////////////////////////////////////////////////////////////////
// CSX_GPIO_Demo_eVCDlg dialog

CSX_GPIO_Demo_eVCDlg::CSX_GPIO_Demo_eVCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSX_GPIO_Demo_eVCDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSX_GPIO_Demo_eVCDlg)
	m_setdir = _T("");
	m_getdir = _T("");
	m_write = _T("");
	m_read = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSX_GPIO_Demo_eVCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSX_GPIO_Demo_eVCDlg)
	DDX_Control(pDX, IDC_COMBO2, m_port);
	DDX_Text(pDX, IDC_EDIT1, m_setdir);
	DDX_Text(pDX, IDC_EDIT2, m_getdir);
	DDX_Text(pDX, IDC_EDIT3, m_write);
	DDX_Text(pDX, IDC_EDIT4, m_read);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSX_GPIO_Demo_eVCDlg, CDialog)
	//{{AFX_MSG_MAP(CSX_GPIO_Demo_eVCDlg)
	ON_BN_CLICKED(IDC_BUTTON1, OnSetDir)
	ON_BN_CLICKED(IDC_BUTTON2, OnGetDir)
	ON_BN_CLICKED(IDC_BUTTON3, OnWrite)
	ON_BN_CLICKED(IDC_BUTTON4, OnRead)
	ON_EN_CHANGE(IDC_EDIT1, OnChangeDir)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeData)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSX_GPIO_Demo_eVCDlg message handlers

BOOL CSX_GPIO_Demo_eVCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			         // Set big icon
	SetIcon(m_hIcon, FALSE);		         // Set small icon

	CenterWindow(GetDesktopWindow());	     // center to the hpc screen

	return TRUE;                             // return TRUE  unless you set the focus to a control
}



void CSX_GPIO_Demo_eVCDlg::OnSetDir()
{
	int      Last_Num=0;
	bool     num_flag=0;
    CString  setdirs = m_setdir;
	int      nPort   = m_port.GetCurSel();

	if(2==setdirs.GetLength())
	{
	   char fir_num    = (char)setdirs.GetAt(0);
	   char sec_num    = (char)setdirs.GetAt(1);
       int  re_fir_num = Ascii2Hex(&fir_num);
       int  re_sec_num = Ascii2Hex(&sec_num);
	   if(re_fir_num>=0 && re_sec_num>=0)
	   {
		    Last_Num=re_fir_num*16 + re_sec_num;
			num_flag=1;
	   }
	 }

     if (1==setdirs.GetLength())
	 {
        char fir_num = (char)setdirs.GetAt(0);
		Last_Num=Ascii2Hex(&fir_num);
	    if(Last_Num!=-1)
		num_flag=1;
	 }

	 if(1==num_flag)
	 {
		data_mark=Last_Num;
		UpdateData(FALSE);
	    SetPortDir(nPort,Last_Num);
	 }
     else
	 {
         MessageBox(_T("Please input 00~FF."),_T("Warning"),MB_OK);
		 m_setdir=_T("0");
	     UpdateData(FALSE);
	 }

}

void CSX_GPIO_Demo_eVCDlg::OnGetDir()
{
	int nPort = m_port.GetCurSel();
	int get_data;
	UpdateData();
	get_data= GetPortDir(nPort);
    m_getdir.Format(_T("%X"),get_data);
	UpdateData(FALSE);
}

void CSX_GPIO_Demo_eVCDlg::OnWrite()
{

	int  last_num =0;
	bool num_flag =0;
	int  nPort     = m_port.GetCurSel();
	CString wdatas= m_write;

	if (2==wdatas.GetLength())
	{
       char fir_num = (char)wdatas.GetAt(0);
	   char sec_num  = (char)wdatas.GetAt(1);
       int re_fir_num= Ascii2Hex(&fir_num);
       int re_sec_num= Ascii2Hex(&sec_num);
	   if(re_fir_num>=0 && re_sec_num>=0)
	   {
		    last_num=re_fir_num*16 + re_sec_num;
			num_flag=1;
	   }
	}

    if (1==wdatas.GetLength())
	{
        char fir_num = (char)wdatas.GetAt(0);
		last_num=Ascii2Hex(&fir_num);
	    if(last_num!=-1)
		num_flag=1;
	}

	if(1==num_flag)
	{
		UpdateData(FALSE);
		last_num &= data_mark;
		WritePort(nPort,  last_num);
	}
    else
	{
	    MessageBox(_T("Please input 00~FF."),_T("Warning"),MB_OK);
		m_write=_T("0");
        UpdateData(FALSE);
	}
}

void CSX_GPIO_Demo_eVCDlg::OnRead()
{
	int nPort = m_port.GetCurSel();
	int rdatad=ReadPort(nPort)&(~data_mark);
    m_read.Format(_T("%X"),rdatad);
	UpdateData(FALSE);

}

void CSX_GPIO_Demo_eVCDlg::OnChangeDir()
{
	UpdateData(TRUE);
	CString isover = m_setdir;
    if(isover.GetLength()>MAX_ASCII_LENGTH || isover.GetLength()==0)
	{
	   MessageBox(_T("Please input 00~FF."),_T("error"),MB_ICONHAND|MB_OK);
       m_setdir = _T("0");
	   UpdateData(FALSE);
	}

}


void CSX_GPIO_Demo_eVCDlg::OnChangeData()
{
	UpdateData(TRUE);
	CString isover = m_write;
    if(isover.GetLength()>MAX_ASCII_LENGTH || isover.GetLength()==0)
	{
	   MessageBox(_T("Please input 00~FF."),_T("error"),MB_ICONHAND|MB_OK);
       m_write = _T("0");
	   UpdateData(FALSE);
	}
}
