
;---------------------------------------------------------------------
;
;	FLASH.ASM: Example on how to enable FLASH disk interface
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;----------------------------------------------------------------------
;

	INCLUDE SUPERSET.INC
;
;-------------- INITIALIZATION ------------------------------------

CODE	SEGMENT
	ASSUME  CS:CODE, DS:CODE, ES:CODE, SS:CODE


EXTRN   open_ebu:near, open_ibu:near, close_386sl:near


        ORG	100H

start:

; setup PI-bus watchdog timer

	cli
	call	open_ibu
	mov	dx, EBC2CR
	mov	ax, 000FH
	out	dx, ax
	call	close_386SL
	

; setup Flash disk interface

        call	open_ebu
        mov     dx, ISAWINDOW
        mov     ax, 8040H       	; enable ISA window, set starting 
        out     dx, ax          	; address to 4 MB
        call	close_386SL


; enable Flash disk interface

        call	open_cpupwrmode
        mov     dx, CPUPWRMODE
        in      ax, dx
        or      ax, 0008H       	; set flash disk enable bit
        out     dx, ax
        call	close_cpupwrmode


; mov memory from B000 segment to A0000 segment

	push	ds
	push	es
	push	si
	push	di
	push	cx
	mov	ax, 0B800H
	mov	ds, ax
	mov	ax, 0D000H
	mov	es, ax
	xor	ax, ax
	mov	si, ax
	mov	di, ax
	mov	cx, 08000H
	cld
	rep	movsw
	pop	cx	
	pop	di
	pop	si
	pop	es
	pop	ds
	
	sti
	
	mov	ax, 4C00H      		; terminate program
	int	21H

CODE	ENDS		       		; END CODE SEGMENT
	END	entry
