
;------------------------------------------------------------------
;
;	FLASHVPP.ASM: This file contains routines to enable flash memory
;	write.
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by McGraw-Hill, Inc 1992. All rights reserved
;
;-----------------------------------------------------------------

	
	INCLUDE	SUPERSET.INC

CODE	SEGMENT	BYTE	PUBLIC 'CODE'
	ASSUME CS:CODE

EXTRN	open_ibu:near, open_ebu:near, close_386sl:near
PUBLIC	WRITE_ONLY, READ_ONLY, VPP_ON, VPP_OFF


;----------------------------------------------------------------
;
; Routine to write Flash memory
;
;----------------------------------------------------------------	     

WRITE_ONLY	PROC	NEAR

	push	ax
	push	dx

	call    open_ibu
        mov     dx, 308H
        mov     ax, 05555H              ;write cycles go to ISA-bus (ROM)
        out     dx, ax			;read cycles go to on-board memory
        mov     dx, 30ah
        out     dx, ax
        mov     dx, 30CH
        out     dx, ax
        mov     dx, 30EH
        out     dx, ax
        call	close_386sl

        call	open_ebu                ;enable flash BIOS write
        mov     dx, 300h
        in      ax, dx
        or      ah, 40H
        out     dx, ax
        call	close_386sl

	pop	dx
 	pop	ax
	ret

WRITE_ONLY	ENDP

;----------------------------------------------------------------
;
; Routine to read Flash memory
;
;----------------------------------------------------------------	     

READ_ONLY	PROC	NEAR
	
        push	ax
	push	dx

	call    open_ibu
        mov     dx, 308H
        mov     ax, 0AAAah		; write cycles to on-board memory
	out     dx, ax		; read cycles to ISA-bus (ROM)
        mov     dx, 30ah
        out     dx, ax
        mov     dx, 30CH
        out     dx, ax
        mov     dx, 30EH
        out     dx, ax
	call    close_386sl

        call	open_ebu        ; disable flash BIOS write
        mov     dx, 300h
        in      ax, dx
        and     ah, 0BFH
        out     dx, ax
	call    close_386sl

	pop	dx
	pop	ax

	ret

READ_ONLY	ENDP

;----------------------------------------------------------------
;
; Turn on VPP for Flash memory
;
;----------------------------------------------------------------	     

VPP_ON	PROC	NEAR

	push	ax
	push	bx
	push	cx
	push	dx

        cli
	call	open_360sl
	mov	bl, SMOUT_CNTRL
        call	read_360sl
        and     al, 0DFH
        mov     bh, al
        call	write_360sl
	call	close_360sl
        sti

; wait for power to stabilize

	mov	cx, 500
delay_loop:
	call	delay		; insert 100 us delay
	loop	delay_loop

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

VPP_ON	ENDP

;----------------------------------------------------------------
;
; Turn off VPP for Flash memory
;
;----------------------------------------------------------------	     

VPP_OFF	PROC	NEAR

	push	ax
	push	bx
	push	cx
	push	dx

        cli
	call	open_360sl
	mov	bl, SMOUT_CNTRL
	call    read_360sl
        or      al, 20H
        mov     bh, al
        call	write_360sl
	call	close_360sl
        sti

; wait for power pin to settle

	mov	cx, 500
delay_loop2:
	call	delay		; insert 100 us delay
	loop	delay_loop2

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

VPP_OFF	ENDP



CODE	ENDS
	END

