
;------------------------------------------------------------------
;
;       INIT.ASM: This program demonstrates how to enter SMM mode.
;
;       Author: Desmond Yuen
;
;       Date:   Dec 19, 1992
;
;       Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;-----------------------------------------------------------------



	INCLUDE SUPERSET.INC

CR      EQU     13
LF      EQU     10

CODE    SEGMENT PUBLIC  'CODE'
	ASSUME  CS:CODE, DS:CODE

EXTRN   open_omcu:near, close_386sl:near, open_360sl:near, write_360sl:near
EXTRN   close_360sl:near, open_ibu:near,close_cpupwrmode:near
EXTRN   read_360sl:near


	ORG     100h

; Open SM file

entry:

	mov     ah, 3Dh                 ;open file function
	mov     al, 00h                 ;read only
	mov     dx, offset SmFile
	Int     21h
	jnc     sm_file_open            ;if no error, then we are done here!
	jmp     bad_sm_exit

;Read the SM file, and close it

sm_file_open:
	mov     Handle, ax              ;save the handle
	push    ax
	push    bx
	push    cx
	push    dx
	mov     dx, offset version
	mov     ah, 09h
	int     21h

; Mark SmSeg as write-only memory

	call    open_ibu
	mov     ax, 30Ah
	mov     dx, ax
	mov     ax, 0FFFFh
	out     dx, ax
	call    close_386sl

; read in system management file

	mov     ax, SmSeg
	mov     ds, ax
	xor     dx, dx                  ;ds:dx = SM memory buffer
	mov     cx, 8000h               ;read half of SM image
	mov     bx, cs:Handle           ;file handle
	mov     ah, 3Fh                 ;read file
	Int     21h
	jc      rd_sm_exit              ;error occurred, exit
	sub     ax, 8000h               ;test for complete read
	jc      rd_sm_exit              ;error occurred, exit


; Mark SmSeg as read-only memory

	call    open_ibu
	mov     ax, 30Ah
	mov     dx, ax
	mov     ax, 05555h
	out     dx, ax
	call    close_386sl
	
; verify file read

	xor     dx, dx
	mov     cx, 1                   ;read one byte to verify file read
	mov     ah, 3Fh                 ;read file
	Int     21h
	cmp     ax, 0                   
	jne     bad_sm_exit             
	clc
	jmp     rd_sm_exit

bad_sm_exit:

	stc
	mov     dx, offset filerr       ;display file error message
	mov     ah, 09h
	int     21h

rd_sm_exit:

	pushf
	mov     ax, cs
	mov     ds, ax                  ;restore ds                     
	mov     bx, Handle
	mov     ah, 3Eh                 ;close file function
	Int     21h
	popf
	pop     dx
	pop     cx
	pop     bx
	pop     ax
	call    open_omcu               ; select SmSeg as the on-board
	mov     ax, MCSMRAM             ; memory segment
	mov     dx, ax
	mov     al, 06h
	out     dx, al
	call    close_386sl

; System management hardware initialization             


	call    open_360sl
	mov     bl, SM_REQ_CNTRL        ; enable external SMI
	call    read_360sl
	or      al, 0c0h
	mov     bh, al
	call    write_360sl
	call    close_360sl

exit:

	mov     ax, 4C00H               ; terminate program
	int     21H


;------------------------------------------------------------------

; OPTIONAL STACK - CAUTION - MUST USE FUNCTION 4CH IF LOCAL STACK
; IS USED

Handle  dw      ?
SmFile  db      'kernel.bin',0
filerr  db      'Error: Cannot open file "KERNEL.BIN"',cr,lf,'$'
version db      cr,lf
	db      'System Management Kernel Version 0.01',cr,lf
	db      'System Management Kernel Installed.',cr,lf
	db      cr,lf,'$'
SmSeg   EQU     0E800h
;
;------------------------------------------------------------------

CODE    ENDS                                    ; END CODE SEGMENT
	END     entry
