
;-------------------------------------------------------------
;
;	LSTDBY.ASM: This file contains routines that handle
;	local standby requests
;
;	Author:	Desmond Yuen
;
;	Date: Dec 19, 1992
;
;	Revision History:
;
;	Copyright 1992 by McGraw-Hill, Inc. All rights reserved.
;
;------------------------------------------------------------------


Include Superset.inc

code	segment	public	'code'
	assume	cs:code

PUBLIC	exec_lstdby, exec_lstdby_0, exec_lstdby_1,exec_lstdby_2
PUBLIC  exec_lstdby_3,exec_lstdby_4, exec_lstdby_5, smout_off

EXTRN   open_360sl:near, read_360sl:near, write_360sl:near, close_360sl:near

;       SMOUT PINS ASSIGNMENT:

;      --------------------------
;     | SMOUT0 | FLOPPY DRIVE    |
;      --------------------------
;     | SMOUT1 | SERIAL PORT A   |
;      --------------------------
;     | SMOUT2 - SERIAL PORT B   |
;      --------------------------
;     | SMOUT3 - HARD DISK       |
;      --------------------------
;     | SMOUT4 - PARALLEL PORT   |
;      --------------------------
;     | SMOUT5 - FLASH VPP       |
;       --------------------------


;------------------------------------------------------------------
;
;	exec_lstdby: Procedure to process local standby request
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_lstdby	proc	near		; local standby request
	mov	al, 0e5h		; local standby req post code
	out	80h, al
	call	open_360sl
	mov	bl, LSTDBY_STS  
	call	read_360sl    		; read LSTDBY request reg
	call	close_360sl
	shr	al, 1			; is it a device 0 standby request
	jnc	stdby1			; no
	call	exec_lstdby_0
stdby1:	shr	al, 1	 		; is it a device 1 standby request
	jnc	stdby2			; no
	call	exec_lstdby_1
stdby2:	shr	al, 1			; is it a device 2 standby request
	jnc	stdby3			; no
	call	exec_lstdby_2
stdby3:	shr	al, 1			; is it a device 3 standby request
	jnc	stdby4	   		; no
	call	exec_lstdby_3
stdby4:	shr	al, 1			; is it a device 4 standby request
	jnc	stdby5			; no
	call	exec_lstdby_4
stdby5:	shr	al, 1			; is it a device 5 standby request
	jnc	nostdby			; no
	call	exec_lstdby_5
nostdby:	
        call    open_360sl      	; clear local standby requset
        mov     bl, LSTDBY_STS
        mov     bh, 0h
        call    write_360sl
        call    close_360sl
	ret
exec_lstdby	endp


;------------------------------------------------------------------
;
;	exec_lstdby_0: Procedure to handle local standby request 0
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_lstdby_0	proc	near

        push    ax
        call    open_360sl
        mov     bl, TRP_ADR_MSK_DEV0    ; enable IO trap
        call    read_360sl
        or      al, 80h
        mov     bh, al
        call    write_360sl

        mov     bl, stdby_tmr_cntrl     ; disable lstdby
        call    read_360sl
        and     al, 0feh
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 0           	; power down floppy drive
        call    smout_off

        mov     al, 0a0h
        out     80h, al
        pop     ax

	ret
exec_lstdby_0	endp



;------------------------------------------------------------------
;
;	exec_lstdby_1: Procedure to handle local standby request 1
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_lstdby_1	proc	near

        push    ax
        call    open_360sl
        mov     bl, TRP_ADR_MSK_DEV1    ; enable IO trap
        call    read_360sl
        or      al, 80h
        mov     bh, al
        call    write_360sl

        mov     bl, stdby_tmr_cntrl     ; disable lstdby
        call    read_360sl
        and     al, 0fdh
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 1           	; disable RS232 buffer
        call    smout_off

        mov     al, 0a1h
        out     80h, al
        pop     ax
	
	ret
exec_lstdby_1	endp



;------------------------------------------------------------------
;
;	exec_lstdby_2: Procedure to handle local standby request 2
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_lstdby_2	proc	near

        push    ax
        call    open_360sl
        mov     bl, TRP_ADR_MSK_DEV2    ; enable IO trap
        call    read_360sl
        or      al, 80h
        mov     bh, al
        call    write_360sl

        mov     bl, stdby_tmr_cntrl     ; disable lstdby
        call    read_360sl
        and     al, 0fbh
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 2           	; disable RS232 buffer
        call    smout_off

        mov     al, 0a2h
        out     80h, al
        pop     ax
	ret
exec_lstdby_2	endp



;------------------------------------------------------------------
;
;	exec_lstdby_3: Procedure to handle local standby request 3
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_lstdby_3	proc	near

        push    ax
        call    open_360sl
        mov     bl, TRP_ADR_MSK_DEV3    ; enable IO trap
        call    read_360sl
        or      al, 80h
        mov     bh, al
        call    write_360sl

        mov     bl, stdby_tmr_cntrl     ; disable lstdby
        call    read_360sl
        and     al, 0f7h
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 3           	; power down hard disk
        call    smout_off

        mov     al, 0a3h
        out     80h, al
        pop     ax
	ret
exec_lstdby_3	endp



;------------------------------------------------------------------
;
;	exec_lstdby_4: Procedure to handle local standby request 4
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_lstdby_4	proc	near

        push    ax
        call    open_360sl
        mov     bl, TRP_ADR_MSK_DEV4    ; enable IO trap
        call    read_360sl
        or      al, 80h
        mov     bh, al
        call    write_360sl

        mov     bl, stdby_tmr_cntrl     ; disable lstdby
        call    read_360sl
        and     al, 0efh
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 4           	; disable LPT buffer
        call    smout_off

        mov     al, 0a4h
        out     80h, al
        pop     ax
	ret
exec_lstdby_4	endp



;------------------------------------------------------------------
;
;	exec_lstdby_5: Procedure to handle local standby request 5
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_lstdby_5	proc	near

; not used here

	ret
exec_lstdby_5	endp



;-------------------------------------------------------------
;
;       smout_off:      Reset smout pin
;
;       Input:  bh = pin number
;
;       Output: None
;
;-------------------------------------------------------------



smout_off       proc near
        call	open_360sl
off_pin:
        cmp     bh, 0           	; pin 0?
        ja      off_pin1
        mov     bh, 0FEh
        jmp     off_send
off_pin1:   
	cmp     bh, 1           	; pin 1?
        ja      off_pin2
        mov     bh, 0FDh
        jmp     off_send
off_pin2:   
	cmp     bh, 2           	; pin 2?
        ja      off_pin3
        mov     bh, 0FBh
        jmp     off_send
off_pin3:   
	cmp     bh, 3           	; pin 3?
        ja      off_pin4
        mov     bh, 0F7h
        jmp     off_send
off_pin4:   
	cmp     bh, 4           	; pin 4?
        ja      off_pin5
        mov     bh, 0EFh
        jmp     off_send
off_pin5:   
	cmp     bh,  5           	; pin 5?
        mov     bh, 0DFh
off_send:
	mov	bl, SMOUT_CNTRL
        call	read_360sl
        and     al, bh
	mov	bh, al
        call	write_360sl
        call	close_360sl
        ret

smout_off	endp


code	ends
	end


