/**
* global structures
**/

struct dsp_evres { /* evaluation result */
	int	etype;	/* type of evaluation result ACC, INT, FPT, FRC */
	int	bcount; /* byte count of characters in string */
	int	wcount; /* word count of evaluated string */
	union{
		double	fvalue; /* floating point value 			  */
		long	*wvalue;/* pointer to string word array */
		struct	{
			long ext,high,low; /* each long holds 3 bytes of data */
		} xvalue;	/* fixed point fractional value */
	}uval;
	int	force;		/* forced size (long,short,etc.) */
	int	fwd_ref;	/* NO = result contains no forward refs */
	int	mspace; 	/* memory space attribute */
   int   size;   /* number of active bytes 3=short 6=long 7=accumulator */
};

struct dsp_obj{
	int count;		/* word count (1 or 2)			*/
	long opcode;		/* base opcode				*/
	long postword;		/* post word				*/
};

/*
*   GLOBAL STRUCTURES
*/
struct dsp_mac{
	char macfn[80]; /* macro filename */
	long macpos; /* position in file */
	struct dsp_mac *macprev; /* pointer to previous macro on stack */
};


struct	 dsp_window   {	/* VIRTUAL SCREEN POINTERS */
	int next,head,tail;
   char dbuf[100][120];
};

struct dsp_sstat   {	/* SUMMARY OF SIMULATOR STATUS */
	long	occ_ctr;	/* counter for step,trace,or breakpoint occurrence */
	int	brk_num; 	/* proceed to this breakpoint */
	int	radix;		/* default base number for command entry */
   int   gomode;     /* 0=go, 1=trace inst 2=trace cy 3=step ins 4=step cy */
	FILE	*fileptrs[2];	/* log file pointers */
	char	dspfiles[2][80];	/* logging file names */
                        /* dspfiles[0]=commands only */
                        /* dspfiles[1]=all log output*/
};
struct dsp_cmd {
char gcs[81]; /* global command string buffer */
int  gcf[81]; /* global command string field positions */
char gcvf[81]; /* global command value type flags */
int gcvf2[81]; /* global command value flag 2 for index 1 */
int gcvf3[81]; /* global command value flag 3 for index 2 */
long gcv1[81]; /* global command values for fields */
long gcv1h[81]; /* global command values for fields */
long gcv1e[81]; /* global command values for fields */
long gcv2[81]; /* global command values for second position of fields */
double gcvd[81]; /* float double representation */
char *gcsp;    /*pointer to original string being parsed */
int gerrpos; /* position in string with error */
};

struct dsp_bp  {
                 int bpnum; /* breakpoint number 1-99 */
                 int bptype; /* 0=read 1=write 2=access memory */
                             /* 3=read 4=write 5=access register */
                             /* 6=expression  7=simple expression*/
                 int bpcycle; /* 0=instruction boundary, 1=cycle boundary check */
                 int bpaction; /* break action */
                 char bpexp[80]; /* breakpoint expression */
                 long bpcount; /* breakpoint counter */
                 int bpreg; /* register or memory type index */
                 long bpstadd; /* start address for memory breakpoints */
                               /* also holds register number */
                 long bpspadd; /* end address memory breakpoints */
                 long bpovadd; /* wrap around memory address */
                 struct dsp_bp *bpnext; /* point to next breakpoint */
                };

struct dsp_mdsp { /* describes enable status of a block of memory */
   int menable; /* 0=off, 1=on, 2=read, 3=write, 4=access */
   long mbegin; /* beginning address of block */
   long mend;  /* end address of block */
   struct dsp_mdsp *mnext; /* next block */
   };

struct dsp_hlp { int index;   /* current index within display */
   char **mhlp; /* pointer to main helplines */
   char **qhelp;   /* when you type question mark */
   };

struct dsp_nest {
   long neststadd; /* start of loop position in file 0=not defined */
   int  nestspadd; /* end of loop flag 0=not defined  1=defined */
   long nestrep; /* nest repeat count 0=undefined -1=forever */
   struct dsp_nest *nestnext; /* further nesting of loop */
   };

struct dsp_iolist {
   char iofn[80]; /* io file name */
   char ioexp[80]; /* memory or port or pin group names */ 
   FILE *iofp; /* pointer to file structure */
   int  iotype ; /*0= memory,1= port,2= pin 3=pin group 4=pin-to-pin 5=register*/
   int  ioindex ; /* memory type or port type or register number */
   long iostadd; /* memory address or start pin number */
   int iospadd; /* stop pin number  */
   long iopos;  /* current file position */
   long iodata; /* current data value */
   long ionextdata; /* next data value in timed mode transfers */
   int  ioabs;  /* absolute=1 or relative=0 mode of timed data */
   int  ioradix; /* radix of input data  0=decimal, 1=fractional, 2=hex */
   long iorep;  /* data repeat count 0=not defined -1=forever; also absolute mode cycle*/
   struct dsp_nest *ionest; /* for nested parentheses NULL=no nesting*/
   struct dsp_iolist *ionext; /* for next in linked list NULL=end of list*/
   };


struct dsp_var {
   long dsp_reg[480]; /* DSP REGISTER VALUES */
   long pram[2048];  /* DSP ON-CHIP P RAM MEMORY (set at 56000 size as maximum )*/
   long xram[256]; /* DSP ON-CHIP X RAM MEMORY */
   long yram[256]; /* DSP ON-CHIP Y RAM MEMORY */
   long bootrom[32]; /* DSP ON-CHIP BOOTSTRAP ROM MEMORY */
   long xrom[256];   /* DSP ON-CHIP X DATA ROM MEMORY */
   long yrom[256];   /* DSP ON-CHIP Y DATA ROM MEMORY */
   int  dsp_flag[230]; /* DSP FLAG AND SHORT REGISTER VALUES */
   int  dsprw[119];  /* READ/WRITE REGISTER FLAGS FOR DISPLAY */
                        /* 1 if read, 2 if written , 3 if both r/w or 0 if none */
                        /* register read/write status */
   int dsprb[119]; /* READ/WRITE REGISTER FLAGS USED FOR BREAKPOINT DETECTION */
                     /* 1 if read, 2 if written , 3 if both r/w or 0 if none */
   int  CTRLBR; /* Control break flag from user keyboard interrupt */
   struct dsp_sstat sim_stat; /* Simulator status structure */
   char pathwork[80]; /* Pathname selected by user for working file prefix */
   struct dsp_mdsp *mdp[5]; /*L,P,PB,X,Y memory display flags structure */
   struct dsp_mdsp *mdn[5]; /*L,P,PB,X,Y memory display now structure*/
   struct dsp_mdsp *mdr[5]; /*L,P,PB,X,Y memory display radix selection */
   struct dsp_mdsp *mdb[5]; /*L,P,PB,X,Y memory io breakpoints selection */
   int dispest[102]; /* display enable status -1=dont exist 0=off,1=on,2=read,3=rw,4=w */
   int disprwst[102]; /* display read-write status 3=read&wr,2=read,1=written,0=off */
   int dispattr[89];  /* register display radix selection */
   struct dsp_bp gbp; /* Breakpoint header structure */
   int insert_o; /* Flag selectin insert or overwrite mode of keyboard entry */
   int in_macro; /* Flag indication a macro command is being executed */
   int executing; /* Flag indicating dsp cycle exectution.  Not at a breakpoint */
   FILE *macfp; /* the currently open macro file (only 1 open at a time) */
   struct dsp_mac *mactop; /* Linked list of nested macros being executed */
   int curline;  /* Current display line for device */
   int curclm;   /* Current display column for device */
   int scrnest; /* Display refresh nest depth */
   struct dsp_iolist *iors; /* stack mode reads from files */
   struct dsp_iolist *iort; /* timed mode reads from files */
   struct dsp_iolist *iows; /* stack mode writes to files */
   struct dsp_iolist *iowt; /* timed mode writes to files */
   struct dsp_window dsp_win; /* window buffer for device */
   char prevcmd[81]; /* previous command (for repeat of command) */
   int devindex; /* device number when multiple devices are referenced */
   int devtype; /* device type (0=56000, 1=56001 etc) */
   };


struct dsp_const {
   long bootrom[32]; /* Values used to initialize the on-chip bootstrap rom */
   long xrom[256]; /* Values used to initialize the on-chip x data rom */
   long yrom[256]; /* Values used to initialize the on-chip y data rom */
   char * cmd_short[23]; /* short forms of simulator commands */
   char * full_cmd[23];   /* fully expanded forms of simulator commands */
   int pinxref[107];
   int pinnum[74];
   int pinbank[74]; /* 0=interrupt/mode control 1,2,3,4=port a,b,c,d */
   char *disp_reg[89];
   int reg_indx[89];
   int reg_szattr[89];
   int dispattr[89];
   char *revnum;
   int reg_help[89];
   char * break_act[7];
   int dispestd[102]; /* default values for display enable status */
   char * dev_config[2]; /* possible devices types*/
   int viewdev; /* device being viewed on screen */
   int CTRLBR;  /* global break signal */
   int num_dsps; /* number of dsp devices being supported */
   struct dsp_var **dsp_list;
   long bitset[24]; /* bit masks for bits 1 through 24 */
   char *gerrptr; /* pointer to error message */
   char gerrmsg[90]; /* global error message */
   int numlines; /* number of lines of display */
   int breakdev; /* device that will halt if CTRLC break occurs */
   int cmdline;  /* display line used for command entry */
   };
struct dsp_help{
   struct dsp_hlp hlpmain;
   struct dsp_hlp hlpiasm;
   struct dsp_hlp hlpimch;
   struct dsp_hlp hlpirch;
   struct dsp_hlp hlpterm;
   struct dsp_hlp hlptrm2;
   struct dsp_hlp hlptemp;
   struct dsp_hlp hlpeach[25];
   char **hlpreg[89];
   };



